/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.connect.ConnectHandler;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.gui.FriendServerEntry;
import net.creeperhost.minetogether.connect.netty.NettyClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.mixin.connect.ServerSelectionListAccessor;
import net.creeperhost.minetogether.session.JWebToken;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ServerListAppender {
    public static final ServerListAppender INSTANCE = new ServerListAppender();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component CANT_CONNECT_MESSAGE = new TranslatableComponent("multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    private final List<Connection> connections = Collections.synchronizedList(Lists.newArrayList());
    private ServerSelectionList serverList;
    private JoinMultiplayerScreen multiplayerScreen;
    private Map<RemoteServer, FriendServerEntry> serverEntries = new HashMap<RemoteServer, FriendServerEntry>();
    private int tick = 0;

    public void init(ServerSelectionList serverList, JoinMultiplayerScreen multiplayerScreen) {
        this.serverList = serverList;
        this.multiplayerScreen = multiplayerScreen;
        ConnectHandler.clearAndReset();
        ConnectHandler.updateFriendsSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (this.tick++ % 20 != 0 || this.serverList == null || this.multiplayerScreen == null) {
            return;
        }
        ConnectHandler.updateFriendsSearch();
        boolean dirty = false;
        ArrayList<RemoteServer> remoteServers = new ArrayList<RemoteServer>(ConnectHandler.getRemoteServers());
        for (RemoteServer remoteServer : remoteServers) {
            Profile profile;
            if (this.serverEntries.containsKey(remoteServer) || (profile = ConnectHandler.getServerProfile(remoteServer)).isStale()) continue;
            this.serverEntries.put(remoteServer, new FriendServerEntry(this.multiplayerScreen, remoteServer, profile, this));
            dirty = true;
        }
        ArrayList toRemove = new ArrayList();
        this.serverEntries.forEach((server, entry) -> {
            if (!remoteServers.contains(server)) {
                toRemove.add(server);
            }
        });
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this.serverEntries::remove);
            dirty = true;
        }
        if (dirty) {
            ((ServerSelectionListAccessor)this.serverList).invokeRefreshEntries();
        }
        List<Connection> list = this.connections;
        synchronized (list) {
            Iterator<Connection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (connection.m_129536_()) {
                    connection.m_129483_();
                    continue;
                }
                iterator.remove();
                connection.m_129541_();
            }
        }
    }

    public void remove() {
        this.serverList = null;
        this.multiplayerScreen = null;
        this.serverEntries.clear();
        this.removeAll();
    }

    public void addEntries() {
        if (this.serverList == null) {
            return;
        }
        for (FriendServerEntry entry : this.serverEntries.values()) {
            this.serverList.m_7085_((AbstractSelectionList.Entry)entry);
        }
    }

    public void pingServer(final RemoteServer server, final Profile profile) throws Exception {
        JWebToken token = (JWebToken)MineTogetherClient.getSession().get().orThrow();
        final Connection connection = NettyClient.connect(ConnectHandler.getSpecificEndpoint(server.node), token, server.serverToken);
        this.connections.add(connection);
        server.motd = new TranslatableComponent("multiplayer.status.pinging");
        server.ping = -1L;
        server.playerList = null;
        connection.m_129505_((PacketListener)new ClientStatusPacketListener(){
            private boolean success;
            private boolean receivedPing;
            private long pingStart;

            public void m_6440_(ClientboundStatusResponsePacket clientboundStatusResponsePacket) {
                if (this.receivedPing) {
                    connection.m_129507_((Component)new TranslatableComponent("multiplayer.status.unrequested"));
                } else {
                    this.receivedPing = true;
                    ServerStatus serverStatus = clientboundStatusResponsePacket.m_134897_();
                    server.motd = serverStatus.m_134905_() != null ? serverStatus.m_134905_() : TextComponent.f_131282_;
                    if (serverStatus.m_134915_() != null) {
                        server.version = new TextComponent(serverStatus.m_134915_().m_134967_());
                        server.protocol = serverStatus.m_134915_().m_134968_();
                    } else {
                        server.version = new TranslatableComponent("multiplayer.status.old");
                        server.protocol = 0;
                    }
                    if (serverStatus.m_134914_() != null) {
                        server.status = ServerListAppender.formatPlayerCount(serverStatus.m_134914_().m_134926_(), serverStatus.m_134914_().m_134923_());
                        ArrayList list = Lists.newArrayList();
                        GameProfile[] gameProfiles = serverStatus.m_134914_().m_134927_();
                        if (gameProfiles != null && gameProfiles.length > 0) {
                            GameProfile[] var5 = gameProfiles;
                            int var6 = gameProfiles.length;
                            for (int var7 = 0; var7 < var6; ++var7) {
                                GameProfile gameProfile = var5[var7];
                                list.add(new TextComponent(gameProfile.getName()));
                            }
                            if (gameProfiles.length < serverStatus.m_134914_().m_134926_()) {
                                list.add(new TranslatableComponent("multiplayer.status.and_more", new Object[]{serverStatus.m_134914_().m_134926_() - gameProfiles.length}));
                            }
                            server.playerList = list;
                        }
                    } else {
                        server.status = new TranslatableComponent("multiplayer.status.unknown").m_130940_(ChatFormatting.DARK_GRAY);
                    }
                    String string = null;
                    if (serverStatus.m_134916_() != null) {
                        String string2 = serverStatus.m_134916_();
                        if (string2.startsWith("data:image/png;base64,")) {
                            string = string2.substring("data:image/png;base64,".length());
                        } else {
                            LOGGER.error("Invalid server icon (unknown format)");
                        }
                    }
                    if (!Objects.equals(string, server.getIconB64())) {
                        server.setIconB64(string);
                    }
                    this.pingStart = Util.m_137550_();
                    connection.m_129512_((Packet)new ServerboundPingRequestPacket(this.pingStart));
                    this.success = true;
                }
            }

            public void m_7017_(ClientboundPongResponsePacket clientboundPongResponsePacket) {
                long l = this.pingStart;
                long m = Util.m_137550_();
                server.ping = m - l;
                connection.m_129507_((Component)new TranslatableComponent("multiplayer.status.finished"));
            }

            public void m_7026_(Component component) {
                if (!this.success) {
                    ServerListAppender.this.onPingFailed(component, server, profile);
                }
            }

            public Connection m_6198_() {
                return connection;
            }
        });
        try {
            ConnectHost endpoint = ConnectHandler.getEndpoint();
            connection.m_129512_((Packet)new ClientIntentionPacket(endpoint.address(), endpoint.proxyPort(), ConnectionProtocol.STATUS));
            connection.m_129512_((Packet)new ServerboundStatusRequestPacket());
        }
        catch (Throwable var8) {
            LOGGER.error("Failed to ping friend server {}", (Object)server.friend, (Object)var8);
        }
    }

    private static Component formatPlayerCount(int i, int j) {
        return new TextComponent(Integer.toString(i)).m_7220_((Component)new TextComponent("/").m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(Integer.toString(j)).m_130940_(ChatFormatting.GRAY);
    }

    private void onPingFailed(Component component, RemoteServer server, Profile profile) {
        LOGGER.error("Can't ping {}: {}", (Object)(profile.isFriend() ? profile.getFriendName() : profile.getDisplayName()), (Object)component.getString());
        server.motd = CANT_CONNECT_MESSAGE;
        server.status = TextComponent.f_131282_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<Connection> list = this.connections;
        synchronized (list) {
            Iterator<Connection> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                Connection connection = iterator.next();
                if (!connection.m_129536_()) continue;
                iterator.remove();
                connection.m_129507_((Component)new TranslatableComponent("multiplayer.status.cancelled"));
            }
        }
    }

    @Nullable
    public ServerSelectionList getServerList() {
        return this.serverList;
    }
}

